#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

#define KAZ_KEM_SP_J						65
#define KAZ_KEM_SP_SL						128

#define KAZ_KEM_SP_N						"9680693320350411581735712527156160041331448806285781880953481207107506184928318589548473667621840334803765737814574120142199988285"
#define KAZ_KEM_SP_LN						432 // in binary (54 bytes)

#define KAZ_KEM_SP_g1						"65563"
#define KAZ_KEM_SP_g2						"65617"

#define KAZ_KEM_SP_Og1N						"277591565561588714832683121976613472000" //"832774696684766144498049365929840416000"
#define KAZ_KEM_SP_LOg1N					128 // in binary (17 bytes)
#define KAZ_KEM_SP_Og2N						"832774696684766144498049365929840416000" //"23132630463465726236056926831384456000"
#define KAZ_KEM_SP_LOg2N					130 // in binary (17 bytes)

#define KAZ_KEM_PUBLICKEY_BYTES				54 // in bytes for each A1, A2, A3
#define KAZ_KEM_PRIVATEKEY_BYTES			17 // in bytes for each a1, a2, a3

#define KAZ_KEM_EPHERMERAL_PUBLIC_BYTES		54 // in bytes for each B1, B2, B3
#define KAZ_KEM_EPHERMERAL_PRIVATE_BYTES	17 // in bytes for each b1, b2, b3

#define KAZ_KEM_GENERAL_BYTES				54 // in bytes for message, encapsulate message, decapsulate message

extern void init_random();
extern void clear_random();
extern void KAZ_KEM_RANDOM(mpz_t lb, mpz_t ub, mpz_t out);

extern int KAZ_KEM_KEYGEN(unsigned char *kaz_kem_public_key,
                           unsigned char *kaz_kem_private_key);

extern int KAZ_KEM_ENCAPSULATION(unsigned char *encapsulation, unsigned long long *encaplen,
                                 const unsigned char *m, unsigned long long mlen,
                                 const unsigned char *kaz_kem_public_key);

extern int KAZ_KEM_DECAPSULATION(unsigned char *decapsulation, unsigned long long *decaplen,
                                 const unsigned char *encapsulation, unsigned long long encaplen,
                                 const unsigned char *kaz_kem_private_key);

#endif // FILE_H_INCLUDED
